package gov.va.med.mhv.usermgmt.service.adapter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v23.datatype.QSC;
import ca.uhn.hl7v2.model.v23.datatype.RCD;
import ca.uhn.hl7v2.model.v23.message.VQQ_Q02;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.RDF;
import ca.uhn.hl7v2.model.v23.segment.VTQ;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;

class LookupPatientEncoder {
	

		private static final String DEFAULT_FIELD_SEPARATOR = "|";
		private static final String DEFAULT_DELIMITERS = "^~\\&";
		private static final String EVENT = "VQQ";
		private static final String TRIGGER = "Q02";
		private static final String MPI_CONJUNCTION_AND = "AND";
		private static final String MPI_RELATION_EQUALS = "EQ";
		private static final String SENDING_APP = "MPI_LOAD";
		private static final String RECEIVING_APP = "MPI-ICN";
		private static final String QUERY_FORMAT_CODE = "T";
		private static final String QUERY_NAME = "VTQ_PID_ICN_NO_LOAD";
		private static final String VIRTUAL_TABLE_NAME = "ICN";
		private static final String EMPTY_STRING = "";
		private static final String VERSION_NUMBER = "2.3";
		private static final String DATE_FORMAT = "yyyyMMddHHmmssZ";
		private static final String yyyyMMddFormat =  "yyyyMMdd";

		/**
		 * Build a VQQ_Q02 message with MSH, VTD and RDF segments
		 * @throws IOException 
		 * @throws HL7Exception 
		 * @throws DataTypeException 
		 */
		public String encode(String firstName, String lastName, Date birthDate, String ssn, Long userId) throws DataTypeException, HL7Exception, IOException {
			VQQ_Q02 vqq_q02 = null;
			String encoded = null;

			//instantiate a PipeParser, which handles the "traditional encoding"
			Parser parser = new PipeParser();

			//construct message
			vqq_q02 = createQueryMessage( firstName, lastName, birthDate, ssn, userId );
			encoded = parser.encode( vqq_q02 );
					
			System.err.println("LookupPatientEncoder VQQ_Q02 message = " + encoded);
			
			return encoded;
		}

		/*
		String mpiQuery =
			"MSH|^~\\&|MPI_LOAD|200M|MPI-ICN||20050202105053-0500||VQQ^Q02|1107359403070106476|T|2.3\r"+
		    "VTQ|432786934|T|VTQ_PID_ICN_NO_LOAD|ICN|@00108.1^EQ^LOWERY^AND~@00108.2^EQ^RANDY^AND~@00122^EQ^432786934^AND~@00110^EQ^19430914\r"+
		    "RDF|8|@00108.2^ST^30~@00108.3^ST^16~@00108.1^ST^30~@00122^ST^9~@00110^ST^8~@00105^ST^19~@00756^ST^5~@00169^ST^999\r";
		*/
	    
		private VQQ_Q02 createQueryMessage(String firstName, String lastName, Date birthDate, String ssn, Long userId) throws HL7Exception, DataTypeException, IOException {
			VQQ_Q02 vqq_q02 = new VQQ_Q02();
			
			//MSH			
			buildMSHSegment( vqq_q02 );
			
			//VTD
			buildVtqSegment( firstName, lastName, birthDate, ssn, userId, vqq_q02);
			
			//RDF
			buildRdfSegment(vqq_q02);
			
			return vqq_q02;
		}

		
		private void buildRdfSegment(VQQ_Q02 vqq_q02) throws DataTypeException, HL7Exception {
			RDF rdf = vqq_q02.getRDF();
			
			rdf.getNumberOfColumnsPerRow().setValue(String.valueOf( MPIFieldHelper.fieldDefs.length) );
			for(int i = 0; i < MPIFieldHelper.fieldDefs.length; i++) {
				RCD rcd = rdf.getColumnDescription(i);
				rcd.getHL7ItemNumber().setValue(MPIFieldHelper.fieldDefs[i][0]);
				rcd.getHL7DateType().setValue(MPIFieldHelper.fieldDefs[i][1]);
				rcd.getMaximumColumnWidth().setValue(MPIFieldHelper.fieldDefs[i][2]);
			}
		}
	
		private void buildVtqSegment(String firstName, String lastName, Date birthDate, String ssn, Long userId, VQQ_Q02 vqq_q02) throws DataTypeException, HL7Exception {
			VTQ vtq = vqq_q02.getVTQ();
			vtq.getQueryTag().setValue( userId.toString() );
			vtq.getQueryResponseFormatCode().setValue( QUERY_FORMAT_CODE );
			vtq.getVTQueryName().getIdentifier().setValue( QUERY_NAME );
			vtq.getVirtualTableName().getIdentifier().setValue( VIRTUAL_TABLE_NAME );

			QSC c0 = vtq.getSelectionCriteria(0);
			c0.getNameOfField().setValue( MPIFieldHelper.MPI_LAST_NAME );
			c0.getRelationalOperator().setValue( MPI_RELATION_EQUALS );
			c0.getRelationalConjunction().setValue( MPI_CONJUNCTION_AND );
			c0.getValue().setValue( lastName );

			QSC c1 = vtq.getSelectionCriteria(1);
			c1.getNameOfField().setValue( MPIFieldHelper.MPI_FIRST_NAME );
			c1.getRelationalOperator().setValue( MPI_RELATION_EQUALS );
			c1.getRelationalConjunction().setValue( MPI_CONJUNCTION_AND );
			c1.getValue().setValue( firstName );

			QSC c2 = vtq.getSelectionCriteria(2);
			c2.getNameOfField().setValue( MPIFieldHelper.MPI_SSN );
			c2.getRelationalOperator().setValue( MPI_RELATION_EQUALS );
			c2.getRelationalConjunction().setValue( MPI_CONJUNCTION_AND );
			c2.getValue().setValue( ssn );
			
			String bd = dateToyyyyMMdd( birthDate );
			QSC c3 = vtq.getSelectionCriteria(3);
			c3.getNameOfField().setValue( MPIFieldHelper.MPI_DOB );
			c3.getRelationalOperator().setValue( MPI_RELATION_EQUALS );
			c3.getValue().setValue( bd );
		}
		
		private void buildMSHSegment(VQQ_Q02 vqq_q02) throws DataTypeException, IOException {
            MpiProperties properties = MpiProperties.getInstance();
            
			MSH msh = vqq_q02.getMSH();
			
			msh.getFieldSeparator().setValue( DEFAULT_FIELD_SEPARATOR );
			msh.getEncodingCharacters().setValue( DEFAULT_DELIMITERS );

			msh.getSendingApplication().getNamespaceID().setValue( SENDING_APP );
			msh.getSendingFacility().getNamespaceID().setValue( properties.getSendingFacility() );
			msh.getSendingFacility().getUniversalID().setValue( EMPTY_STRING );
			msh.getSendingFacility().getUniversalIDType().setValue( EMPTY_STRING );

			msh.getReceivingApplication().getNamespaceID().setValue( RECEIVING_APP );
			msh.getReceivingFacility().getNamespaceID().setValue( properties.getReceivingFacility() );
			msh.getReceivingFacility().getUniversalID().setValue( EMPTY_STRING );
			msh.getReceivingFacility().getUniversalIDType().setValue( EMPTY_STRING );
			msh.getDateTimeOfMessage().setValue( getMessageDateTime() );

			msh.getMessageType().getMessageType().setValue( EVENT );
			msh.getMessageType().getTriggerEvent().setValue( TRIGGER );
			msh.getMessageControlID().setValue( String.valueOf( System.currentTimeMillis() )+String.valueOf( Math.round( Math.random()*1000000 ) ) );
			msh.getProcessingID().getProcessingID().setValue( EMPTY_STRING ); 
			msh.getVersionID().setValue( VERSION_NUMBER );
			msh.getAcceptAcknowledgementType().setValue( EMPTY_STRING );
			msh.getApplicationAcknowledgementType().setValue( EMPTY_STRING );
		}
		
		private String getMessageDateTime() {
	        SimpleDateFormat sdf = new SimpleDateFormat( DATE_FORMAT );
	        return sdf.format(new java.util.Date());
	    }
		
		private static String dateToyyyyMMdd(Date aDate) {
			if(aDate == null) {
				return EMPTY_STRING;
			}
			
			return new SimpleDateFormat( yyyyMMddFormat ).format(aDate);
		}

}
